/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Wifi2Bar: ImageVector
    get() {
        if (_wifi2Bar != null) {
            return _wifi2Bar!!
        }
        _wifi2Bar = materialIcon(name = "Outlined.Wifi2Bar") {
            materialPath {
                moveTo(12.0f, 10.0f)
                curveToRelative(3.03f, 0.0f, 5.78f, 1.23f, 7.76f, 3.22f)
                lineToRelative(-2.12f, 2.12f)
                curveTo(16.2f, 13.9f, 14.2f, 13.0f, 12.0f, 13.0f)
                curveToRelative(-2.2f, 0.0f, -4.2f, 0.9f, -5.64f, 2.35f)
                lineToRelative(-2.12f, -2.12f)
                curveTo(6.22f, 11.23f, 8.97f, 10.0f, 12.0f, 10.0f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-1.38f, 0.0f, -2.63f, 0.56f, -3.53f, 1.46f)
                lineTo(12.0f, 21.0f)
                lineToRelative(3.53f, -3.54f)
                curveTo(14.63f, 16.56f, 13.38f, 16.0f, 12.0f, 16.0f)
                close()
            }
        }
        return _wifi2Bar!!
    }

private var _wifi2Bar: ImageVector? = null
