/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AllInbox: ImageVector
    get() {
        if (_allInbox != null) {
            return _allInbox!!
        }
        _allInbox = materialIcon(name = "Rounded.AllInbox") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(7.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-3.14f)
                curveToRelative(-0.47f, 0.0f, -0.84f, 0.33f, -0.97f, 0.78f)
                curveTo(14.53f, 11.04f, 13.35f, 12.0f, 12.0f, 12.0f)
                reflectiveCurveToRelative(-2.53f, -0.96f, -2.89f, -2.22f)
                curveToRelative(-0.13f, -0.45f, -0.5f, -0.78f, -0.97f, -0.78f)
                lineTo(5.0f, 9.0f)
                lineTo(5.0f, 6.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                close()
                moveTo(15.87f, 16.0f)
                lineTo(20.0f, 16.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                lineTo(5.0f, 21.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.13f)
                curveToRelative(0.47f, 0.0f, 0.85f, 0.34f, 0.98f, 0.8f)
                curveToRelative(0.35f, 1.27f, 1.51f, 2.2f, 2.89f, 2.2f)
                reflectiveCurveToRelative(2.54f, -0.93f, 2.89f, -2.2f)
                curveToRelative(0.13f, -0.46f, 0.51f, -0.8f, 0.98f, -0.8f)
                close()
            }
        }
        return _allInbox!!
    }

private var _allInbox: ImageVector? = null
