/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AutoFixNormal: ImageVector
    get() {
        if (_autoFixNormal != null) {
            return _autoFixNormal!!
        }
        _autoFixNormal = materialIcon(name = "Rounded.AutoFixNormal") {
            materialPath {
                moveTo(20.45f, 6.0f)
                lineToRelative(0.49f, -1.06f)
                lineTo(22.0f, 4.45f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(-1.06f, -0.49f)
                lineTo(20.45f, 2.0f)
                curveToRelative(-0.18f, -0.39f, -0.73f, -0.39f, -0.91f, 0.0f)
                lineToRelative(-0.49f, 1.06f)
                lineTo(18.0f, 3.55f)
                curveToRelative(-0.39f, 0.18f, -0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(1.06f, 0.49f)
                lineTo(19.55f, 6.0f)
                curveTo(19.72f, 6.39f, 20.28f, 6.39f, 20.45f, 6.0f)
                close()
            }
            materialPath {
                moveTo(17.71f, 9.12f)
                lineToRelative(-2.83f, -2.83f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(2.29f, 17.46f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.83f, 2.83f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(11.17f, -11.17f)
                curveTo(18.1f, 10.15f, 18.1f, 9.51f, 17.71f, 9.12f)
                close()
                moveTo(14.21f, 11.21f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(1.38f, -1.38f)
                lineToRelative(1.41f, 1.41f)
                lineTo(14.21f, 11.21f)
                close()
            }
        }
        return _autoFixNormal!!
    }

private var _autoFixNormal: ImageVector? = null
