/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Cable: ImageVector
    get() {
        if (_cable != null) {
            return _cable!!
        }
        _cable = materialIcon(name = "Rounded.Cable") {
            materialPath {
                moveTo(20.0f, 5.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(0.0f, 6.91f)
                curveToRelative(0.0f, 1.04f, -0.76f, 1.98f, -1.79f, 2.08f)
                curveTo(14.01f, 19.11f, 13.0f, 18.17f, 13.0f, 17.0f)
                lineToRelative(0.0f, -9.86f)
                curveToRelative(0.0f, -2.13f, -1.61f, -3.99f, -3.74f, -4.13f)
                curveTo(6.93f, 2.86f, 5.0f, 4.7f, 5.0f, 7.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(7.0f)
                lineToRelative(0.0f, -6.91f)
                curveToRelative(0.0f, -1.04f, 0.76f, -1.98f, 1.79f, -2.08f)
                curveTo(9.99f, 4.89f, 11.0f, 5.83f, 11.0f, 7.0f)
                lineToRelative(0.0f, 9.86f)
                curveToRelative(0.0f, 2.13f, 1.61f, 3.99f, 3.74f, 4.13f)
                curveTo(17.07f, 21.14f, 19.0f, 19.3f, 19.0f, 17.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(6.0f)
                curveTo(21.0f, 5.45f, 20.55f, 5.0f, 20.0f, 5.0f)
                lineTo(20.0f, 5.0f)
                close()
            }
        }
        return _cable!!
    }

private var _cable: ImageVector? = null
