/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Cameraswitch: ImageVector
    get() {
        if (_cameraswitch != null) {
            return _cameraswitch!!
        }
        _cameraswitch = materialIcon(name = "Rounded.Cameraswitch") {
            materialPath {
                moveTo(16.0f, 7.0f)
                horizontalLineToRelative(-1.0f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(9.0f, 7.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 7.0f, 6.0f, 7.9f, 6.0f, 9.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(9.0f)
                curveTo(18.0f, 7.9f, 17.1f, 7.0f, 16.0f, 7.0f)
                close()
                moveTo(12.0f, 14.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(14.0f, 13.1f, 13.1f, 14.0f, 12.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(9.45f, 0.28f)
                curveTo(9.05f, 0.36f, 8.9f, 0.84f, 9.19f, 1.12f)
                lineToRelative(3.01f, 3.01f)
                curveToRelative(0.32f, 0.31f, 0.85f, 0.09f, 0.85f, -0.35f)
                verticalLineTo(2.04f)
                curveToRelative(4.45f, 0.44f, 8.06f, 3.82f, 8.84f, 8.17f)
                curveToRelative(0.08f, 0.46f, 0.5f, 0.78f, 0.97f, 0.78f)
                curveToRelative(0.62f, 0.0f, 1.09f, -0.57f, 0.98f, -1.18f)
                curveTo(22.61f, 2.89f, 15.79f, -1.12f, 9.45f, 0.28f)
                close()
            }
            materialPath {
                moveTo(11.8f, 19.87f)
                curveToRelative(-0.32f, -0.32f, -0.85f, -0.09f, -0.85f, 0.35f)
                verticalLineToRelative(1.74f)
                curveToRelative(-4.45f, -0.44f, -8.06f, -3.82f, -8.84f, -8.17f)
                curveToRelative(-0.08f, -0.46f, -0.5f, -0.78f, -0.97f, -0.78f)
                curveToRelative(-0.62f, 0.0f, -1.09f, 0.57f, -0.98f, 1.18f)
                curveToRelative(1.24f, 6.92f, 8.06f, 10.93f, 14.4f, 9.53f)
                curveToRelative(0.39f, -0.09f, 0.55f, -0.56f, 0.26f, -0.85f)
                lineTo(11.8f, 19.87f)
                close()
            }
        }
        return _cameraswitch!!
    }

private var _cameraswitch: ImageVector? = null
