/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Elevator: ImageVector
    get() {
        if (_elevator != null) {
            return _elevator!!
        }
        _elevator = materialIcon(name = "Rounded.Elevator") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(8.5f, 6.0f)
                curveToRelative(0.69f, 0.0f, 1.25f, 0.56f, 1.25f, 1.25f)
                curveToRelative(0.0f, 0.69f, -0.56f, 1.25f, -1.25f, 1.25f)
                reflectiveCurveTo(7.25f, 7.94f, 7.25f, 7.25f)
                curveTo(7.25f, 6.56f, 7.81f, 6.0f, 8.5f, 6.0f)
                close()
                moveTo(11.0f, 13.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-1.5f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(17.52f, 13.76f)
                lineToRelative(-1.6f, 2.56f)
                curveToRelative(-0.2f, 0.31f, -0.65f, 0.31f, -0.85f, 0.0f)
                lineToRelative(-1.6f, -2.56f)
                curveTo(13.27f, 13.43f, 13.51f, 13.0f, 13.9f, 13.0f)
                horizontalLineToRelative(3.2f)
                curveTo(17.49f, 13.0f, 17.73f, 13.43f, 17.52f, 13.76f)
                close()
                moveTo(17.1f, 11.0f)
                horizontalLineToRelative(-3.2f)
                curveToRelative(-0.39f, 0.0f, -0.63f, -0.43f, -0.42f, -0.77f)
                lineToRelative(1.6f, -2.56f)
                curveToRelative(0.2f, -0.31f, 0.65f, -0.31f, 0.85f, 0.0f)
                lineToRelative(1.6f, 2.56f)
                curveTo(17.73f, 10.57f, 17.49f, 11.0f, 17.1f, 11.0f)
                close()
            }
        }
        return _elevator!!
    }

private var _elevator: ImageVector? = null
