/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Kitesurfing: ImageVector
    get() {
        if (_kitesurfing != null) {
            return _kitesurfing!!
        }
        _kitesurfing = materialIcon(name = "Rounded.Kitesurfing") {
            materialPath {
                moveTo(6.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(6.0f, 4.1f, 6.0f, 3.0f)
                close()
                moveTo(16.03f, 3.97f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineTo(20.06f, 1.0f)
                horizontalLineToRelative(-2.12f)
                lineToRelative(-1.91f, 1.91f)
                curveTo(15.74f, 3.2f, 15.74f, 3.68f, 16.03f, 3.97f)
                close()
                moveTo(19.15f, 12.0f)
                curveToRelative(-1.29f, 0.0f, -3.11f, 0.53f, -5.06f, 1.38f)
                lineTo(13.0f, 12.16f)
                curveToRelative(-0.38f, -0.42f, -0.92f, -0.66f, -1.49f, -0.66f)
                horizontalLineTo(9.6f)
                lineToRelative(0.0f, -3.5f)
                horizontalLineTo(11.0f)
                curveToRelative(1.52f, 0.0f, 2.94f, -0.49f, 4.09f, -1.32f)
                curveToRelative(0.49f, -0.35f, 0.52f, -1.07f, 0.09f, -1.5f)
                curveToRelative(-0.35f, -0.35f, -0.9f, -0.38f, -1.3f, -0.09f)
                curveTo(13.06f, 5.66f, 12.07f, 6.0f, 11.0f, 6.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 6.0f, 6.0f, 6.9f, 6.0f, 8.0f)
                verticalLineToRelative(4.04f)
                curveToRelative(0.0f, 0.64f, 0.15f, 1.27f, 0.45f, 1.83f)
                lineTo(8.0f, 16.84f)
                curveToRelative(-0.53f, 0.38f, -1.03f, 0.78f, -1.49f, 1.17f)
                curveTo(7.19f, 18.59f, 8.06f, 19.0f, 9.0f, 19.0f)
                curveToRelative(1.2f, 0.0f, 2.27f, -0.66f, 3.0f, -1.5f)
                curveToRelative(0.73f, 0.84f, 1.8f, 1.5f, 3.0f, 1.5f)
                curveToRelative(0.33f, 0.0f, 0.65f, -0.05f, 0.96f, -0.14f)
                curveTo(18.81f, 16.9f, 21.0f, 14.72f, 21.0f, 13.28f)
                curveTo(21.0f, 12.25f, 19.99f, 12.0f, 19.15f, 12.0f)
                close()
                moveTo(9.83f, 15.61f)
                lineTo(9.0f, 13.6f)
                lineToRelative(2.5f, -0.1f)
                lineToRelative(0.7f, 0.77f)
                curveTo(11.64f, 14.55f, 10.42f, 15.23f, 9.83f, 15.61f)
                close()
                moveTo(22.0f, 22.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.87f, 0.0f, -1.73f, -0.24f, -2.53f, -0.7f)
                curveToRelative(-0.29f, -0.16f, -0.65f, -0.17f, -0.94f, 0.0f)
                curveToRelative(-1.59f, 0.9f, -3.47f, 0.9f, -5.06f, 0.0f)
                curveToRelative(-0.29f, -0.16f, -0.65f, -0.16f, -0.94f, 0.0f)
                curveToRelative(-1.59f, 0.9f, -3.47f, 0.9f, -5.06f, 0.0f)
                curveToRelative(-0.29f, -0.16f, -0.65f, -0.16f, -0.94f, 0.0f)
                curveTo(4.73f, 20.76f, 3.87f, 21.0f, 3.0f, 21.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(1.15f, 0.0f, 2.3f, -0.31f, 3.33f, -0.94f)
                curveToRelative(1.66f, 1.11f, 3.78f, 1.01f, 5.58f, 0.14f)
                curveToRelative(1.91f, 1.05f, 4.17f, 1.07f, 6.09f, 0.05f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.95f, 0.5f, 1.97f, 0.75f, 3.0f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveTo(21.55f, 23.0f, 22.0f, 22.55f, 22.0f, 22.0f)
                close()
            }
        }
        return _kitesurfing!!
    }

private var _kitesurfing: ImageVector? = null
