/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Liquor: ImageVector
    get() {
        if (_liquor != null) {
            return _liquor!!
        }
        _liquor = materialIcon(name = "Rounded.Liquor") {
            materialPath {
                moveTo(3.0f, 14.0f)
                curveToRelative(0.0f, 1.3f, 0.84f, 2.4f, 2.0f, 2.82f)
                verticalLineTo(20.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-3.18f)
                curveTo(8.16f, 16.4f, 9.0f, 15.3f, 9.0f, 14.0f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 6.0f, 3.0f, 6.45f, 3.0f, 7.0f)
                verticalLineTo(14.0f)
                close()
                moveTo(5.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(8.0f)
                close()
            }
            materialPath {
                moveTo(20.64f, 8.54f)
                lineToRelative(-0.96f, -0.32f)
                curveTo(19.27f, 8.08f, 19.0f, 7.7f, 19.0f, 7.27f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.28f)
                curveToRelative(0.0f, 0.43f, -0.27f, 0.81f, -0.68f, 0.95f)
                lineToRelative(-0.96f, 0.32f)
                curveTo(11.55f, 8.83f, 11.0f, 9.59f, 11.0f, 10.45f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-9.56f)
                curveTo(22.0f, 9.58f, 21.45f, 8.82f, 20.64f, 8.54f)
                close()
                moveTo(16.0f, 4.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(13.0f, 10.44f)
                lineToRelative(0.95f, -0.32f)
                curveTo(15.18f, 9.72f, 16.0f, 8.57f, 16.0f, 7.28f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(0.28f)
                curveToRelative(0.0f, 1.29f, 0.82f, 2.44f, 2.05f, 2.85f)
                lineTo(20.0f, 10.44f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineTo(10.44f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _liquor!!
    }

private var _liquor: ImageVector? = null
