/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ManageHistory: ImageVector
    get() {
        if (_manageHistory != null) {
            return _manageHistory!!
        }
        _manageHistory = materialIcon(name = "Rounded.ManageHistory") {
            materialPath {
                moveTo(22.75f, 19.0f)
                curveToRelative(0.0f, -0.22f, -0.03f, -0.42f, -0.06f, -0.63f)
                lineToRelative(0.84f, -0.73f)
                curveToRelative(0.18f, -0.16f, 0.22f, -0.42f, 0.1f, -0.63f)
                lineToRelative(-0.59f, -1.02f)
                curveToRelative(-0.12f, -0.21f, -0.37f, -0.3f, -0.59f, -0.22f)
                lineToRelative(-1.06f, 0.36f)
                curveToRelative(-0.32f, -0.27f, -0.68f, -0.48f, -1.08f, -0.63f)
                lineToRelative(-0.22f, -1.09f)
                curveToRelative(-0.05f, -0.23f, -0.25f, -0.4f, -0.49f, -0.4f)
                horizontalLineToRelative(-1.18f)
                curveToRelative(-0.24f, 0.0f, -0.44f, 0.17f, -0.49f, 0.4f)
                lineToRelative(-0.22f, 1.09f)
                curveToRelative(-0.4f, 0.15f, -0.76f, 0.36f, -1.08f, 0.63f)
                lineToRelative(-1.06f, -0.36f)
                curveToRelative(-0.23f, -0.08f, -0.47f, 0.02f, -0.59f, 0.22f)
                lineToRelative(-0.59f, 1.02f)
                curveToRelative(-0.12f, 0.21f, -0.08f, 0.47f, 0.1f, 0.63f)
                lineToRelative(0.84f, 0.73f)
                curveToRelative(-0.03f, 0.21f, -0.06f, 0.41f, -0.06f, 0.63f)
                reflectiveCurveToRelative(0.03f, 0.42f, 0.06f, 0.63f)
                lineToRelative(-0.84f, 0.73f)
                curveToRelative(-0.18f, 0.16f, -0.22f, 0.42f, -0.1f, 0.63f)
                lineToRelative(0.59f, 1.02f)
                curveToRelative(0.12f, 0.21f, 0.37f, 0.3f, 0.59f, 0.22f)
                lineToRelative(1.06f, -0.36f)
                curveToRelative(0.32f, 0.27f, 0.68f, 0.48f, 1.08f, 0.63f)
                lineToRelative(0.22f, 1.09f)
                curveToRelative(0.05f, 0.23f, 0.25f, 0.4f, 0.49f, 0.4f)
                horizontalLineToRelative(1.18f)
                curveToRelative(0.24f, 0.0f, 0.44f, -0.17f, 0.49f, -0.4f)
                lineToRelative(0.22f, -1.09f)
                curveToRelative(0.4f, -0.15f, 0.76f, -0.36f, 1.08f, -0.63f)
                lineToRelative(1.06f, 0.36f)
                curveToRelative(0.23f, 0.08f, 0.47f, -0.02f, 0.59f, -0.22f)
                lineToRelative(0.59f, -1.02f)
                curveToRelative(0.12f, -0.21f, 0.08f, -0.47f, -0.1f, -0.63f)
                lineToRelative(-0.84f, -0.73f)
                curveTo(22.72f, 19.42f, 22.75f, 19.22f, 22.75f, 19.0f)
                close()
                moveTo(19.0f, 21.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveTo(20.1f, 21.0f, 19.0f, 21.0f)
                close()
                moveTo(12.0f, 7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.27f, 0.11f, 0.52f, 0.29f, 0.71f)
                lineToRelative(2.07f, 2.07f)
                lineToRelative(1.04f, -1.79f)
                lineTo(13.0f, 11.59f)
                verticalLineTo(8.0f)
                curveTo(13.0f, 7.45f, 12.55f, 7.0f, 12.0f, 7.0f)
                close()
                moveTo(4.26f, 13.0f)
                curveToRelative(-0.65f, 0.0f, -1.14f, 0.61f, -0.98f, 1.24f)
                curveTo(4.28f, 18.13f, 7.8f, 21.0f, 12.0f, 21.0f)
                curveToRelative(0.02f, 0.0f, 0.05f, 0.0f, 0.07f, 0.0f)
                lineToRelative(-1.21f, -2.09f)
                curveToRelative(-2.75f, -0.45f, -4.96f, -2.51f, -5.64f, -5.18f)
                curveTo(5.11f, 13.29f, 4.71f, 13.0f, 4.26f, 13.0f)
                close()
                moveTo(4.0f, 10.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.36f)
                curveTo(6.65f, 4.32f, 9.17f, 3.0f, 12.0f, 3.0f)
                curveToRelative(4.97f, 0.0f, 9.0f, 4.03f, 9.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -3.86f, -3.14f, -7.0f, -7.0f, -7.0f)
                curveTo(9.63f, 5.0f, 7.53f, 6.19f, 6.26f, 8.0f)
                horizontalLineTo(8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(4.0f)
                close()
            }
        }
        return _manageHistory!!
    }

private var _manageHistory: ImageVector? = null
