/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NearMe: ImageVector
    get() {
        if (_nearMe != null) {
            return _nearMe!!
        }
        _nearMe = materialIcon(name = "Rounded.NearMe") {
            materialPath {
                moveTo(18.75f, 3.94f)
                lineTo(4.07f, 10.08f)
                curveToRelative(-0.83f, 0.35f, -0.81f, 1.53f, 0.02f, 1.85f)
                lineTo(9.43f, 14.0f)
                curveToRelative(0.26f, 0.1f, 0.47f, 0.31f, 0.57f, 0.57f)
                lineToRelative(2.06f, 5.33f)
                curveToRelative(0.32f, 0.84f, 1.51f, 0.86f, 1.86f, 0.03f)
                lineToRelative(6.15f, -14.67f)
                curveToRelative(0.33f, -0.83f, -0.5f, -1.66f, -1.32f, -1.32f)
                close()
            }
        }
        return _nearMe!!
    }

private var _nearMe: ImageVector? = null
