/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PhotoFilter: ImageVector
    get() {
        if (_photoFilter != null) {
            return _photoFilter!!
        }
        _photoFilter = materialIcon(name = "Rounded.PhotoFilter") {
            materialPath {
                moveTo(19.02f, 10.99f)
                lineTo(19.02f, 18.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                lineTo(6.0f, 19.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                lineTo(5.0f, 6.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(5.02f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                lineTo(19.0f, 21.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                verticalLineToRelative(-8.01f)
                curveToRelative(0.0f, -0.55f, -0.44f, -0.99f, -0.99f, -0.99f)
                reflectiveCurveToRelative(-0.99f, 0.44f, -0.99f, 0.99f)
                close()
                moveTo(13.25f, 10.75f)
                lineTo(12.46f, 9.0f)
                curveToRelative(-0.18f, -0.39f, -0.73f, -0.39f, -0.91f, 0.0f)
                lineToRelative(-0.79f, 1.75f)
                lineToRelative(-1.76f, 0.79f)
                curveToRelative(-0.39f, 0.18f, -0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(1.75f, 0.79f)
                lineToRelative(0.79f, 1.76f)
                curveToRelative(0.18f, 0.39f, 0.73f, 0.39f, 0.91f, 0.0f)
                lineToRelative(0.79f, -1.75f)
                lineToRelative(1.76f, -0.79f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(-1.75f, -0.8f)
                close()
                moveTo(17.94f, 6.06f)
                lineToRelative(-0.6f, -1.32f)
                curveToRelative(-0.13f, -0.29f, -0.55f, -0.29f, -0.69f, 0.0f)
                lineToRelative(-0.6f, 1.32f)
                lineToRelative(-1.32f, 0.6f)
                curveToRelative(-0.29f, 0.13f, -0.29f, 0.55f, 0.0f, 0.69f)
                lineToRelative(1.32f, 0.6f)
                lineToRelative(0.6f, 1.32f)
                curveToRelative(0.13f, 0.29f, 0.55f, 0.29f, 0.69f, 0.0f)
                lineToRelative(0.6f, -1.32f)
                lineToRelative(1.32f, -0.6f)
                curveToRelative(0.29f, -0.13f, 0.29f, -0.55f, 0.0f, -0.69f)
                lineToRelative(-1.32f, -0.6f)
                close()
            }
        }
        return _photoFilter!!
    }

private var _photoFilter: ImageVector? = null
