/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Replay: ImageVector
    get() {
        if (_replay != null) {
            return _replay!!
        }
        _replay = materialIcon(name = "Rounded.Replay") {
            materialPath {
                moveTo(12.0f, 5.0f)
                verticalLineTo(2.21f)
                curveToRelative(0.0f, -0.45f, -0.54f, -0.67f, -0.85f, -0.35f)
                lineToRelative(-3.8f, 3.79f)
                curveToRelative(-0.2f, 0.2f, -0.2f, 0.51f, 0.0f, 0.71f)
                lineToRelative(3.79f, 3.79f)
                curveToRelative(0.32f, 0.31f, 0.86f, 0.09f, 0.86f, -0.36f)
                verticalLineTo(7.0f)
                curveToRelative(3.73f, 0.0f, 6.68f, 3.42f, 5.86f, 7.29f)
                curveToRelative(-0.47f, 2.27f, -2.31f, 4.1f, -4.57f, 4.57f)
                curveToRelative(-3.57f, 0.75f, -6.75f, -1.7f, -7.23f, -5.01f)
                curveToRelative(-0.07f, -0.48f, -0.49f, -0.85f, -0.98f, -0.85f)
                curveToRelative(-0.6f, 0.0f, -1.08f, 0.53f, -1.0f, 1.13f)
                curveToRelative(0.62f, 4.39f, 4.8f, 7.64f, 9.53f, 6.72f)
                curveToRelative(3.12f, -0.61f, 5.63f, -3.12f, 6.24f, -6.24f)
                curveTo(20.84f, 9.48f, 16.94f, 5.0f, 12.0f, 5.0f)
                close()
            }
        }
        return _replay!!
    }

private var _replay: ImageVector? = null
