/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalCellularAlt1Bar: ImageVector
    get() {
        if (_signalCellularAlt1Bar != null) {
            return _signalCellularAlt1Bar!!
        }
        _signalCellularAlt1Bar = materialIcon(name = "Rounded.SignalCellularAlt1Bar") {
            materialPath {
                moveTo(6.5f, 20.0f)
                curveTo(5.67f, 20.0f, 5.0f, 19.33f, 5.0f, 18.5f)
                verticalLineToRelative(-3.0f)
                curveTo(5.0f, 14.67f, 5.67f, 14.0f, 6.5f, 14.0f)
                reflectiveCurveTo(8.0f, 14.67f, 8.0f, 15.5f)
                verticalLineToRelative(3.0f)
                curveTo(8.0f, 19.33f, 7.33f, 20.0f, 6.5f, 20.0f)
                close()
            }
        }
        return _signalCellularAlt1Bar!!
    }

private var _signalCellularAlt1Bar: ImageVector? = null
