/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BackHand: ImageVector
    get() {
        if (_backHand != null) {
            return _backHand!!
        }
        _backHand = materialIcon(name = "Sharp.BackHand") {
            materialPath {
                moveTo(2.21f, 10.47f)
                lineTo(5.0f, 9.36f)
                lineTo(7.25f, 15.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(2.5f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(0.0f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(1.5f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(4.5f)
                horizontalLineTo(21.0f)
                verticalLineTo(16.0f)
                curveToRelative(0.0f, 4.42f, -3.58f, 8.0f, -8.0f, 8.0f)
                curveToRelative(-3.26f, 0.0f, -6.19f, -1.99f, -7.4f, -5.02f)
                lineTo(2.21f, 10.47f)
                close()
            }
        }
        return _backHand!!
    }

private var _backHand: ImageVector? = null
