/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BubbleChart: ImageVector
    get() {
        if (_bubbleChart != null) {
            return _bubbleChart!!
        }
        _bubbleChart = materialIcon(name = "Sharp.BubbleChart") {
            materialPath {
                moveTo(7.2f, 14.4f)
                moveToRelative(-3.2f, 0.0f)
                arcToRelative(3.2f, 3.2f, 0.0f, true, true, 6.4f, 0.0f)
                arcToRelative(3.2f, 3.2f, 0.0f, true, true, -6.4f, 0.0f)
            }
            materialPath {
                moveTo(14.8f, 18.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(15.2f, 8.8f)
                moveToRelative(-4.8f, 0.0f)
                arcToRelative(4.8f, 4.8f, 0.0f, true, true, 9.6f, 0.0f)
                arcToRelative(4.8f, 4.8f, 0.0f, true, true, -9.6f, 0.0f)
            }
        }
        return _bubbleChart!!
    }

private var _bubbleChart: ImageVector? = null
