/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.CallMissedOutgoing",
    ReplaceWith( "Icons.AutoMirrored.Sharp.CallMissedOutgoing",
            "androidx.compose.material.icons.automirrored.sharp.CallMissedOutgoing"),
)
public val Icons.Sharp.CallMissedOutgoing: ImageVector
    get() {
        if (_callMissedOutgoing != null) {
            return _callMissedOutgoing!!
        }
        _callMissedOutgoing = materialIcon(name = "Sharp.CallMissedOutgoing") {
            materialPath {
                moveTo(3.0f, 8.41f)
                lineToRelative(9.0f, 9.0f)
                lineToRelative(7.0f, -7.0f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.59f)
                lineTo(12.0f, 14.59f)
                lineTo(4.41f, 7.0f)
                lineTo(3.0f, 8.41f)
                close()
            }
        }
        return _callMissedOutgoing!!
    }

private var _callMissedOutgoing: ImageVector? = null
