/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Discount: ImageVector
    get() {
        if (_discount != null) {
            return _discount!!
        }
        _discount = materialIcon(name = "Sharp.Discount") {
            materialPath {
                moveTo(12.79f, 21.0f)
                lineToRelative(-9.79f, -9.79f)
                lineToRelative(0.0f, 2.83f)
                lineToRelative(9.79f, 9.79f)
                lineToRelative(9.04f, -9.04f)
                lineToRelative(-1.42f, -1.41f)
                close()
            }
            materialPath {
                moveTo(3.0f, 9.04f)
                lineToRelative(9.79f, 9.79f)
                lineToRelative(9.04f, -9.04f)
                lineTo(12.04f, 0.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(9.04f)
                close()
                moveTo(7.25f, 3.0f)
                curveTo(7.94f, 3.0f, 8.5f, 3.56f, 8.5f, 4.25f)
                reflectiveCurveTo(7.94f, 5.5f, 7.25f, 5.5f)
                reflectiveCurveTo(6.0f, 4.94f, 6.0f, 4.25f)
                reflectiveCurveTo(6.56f, 3.0f, 7.25f, 3.0f)
                close()
            }
        }
        return _discount!!
    }

private var _discount: ImageVector? = null
