/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ExpandCircleDown: ImageVector
    get() {
        if (_expandCircleDown != null) {
            return _expandCircleDown!!
        }
        _expandCircleDown = materialIcon(name = "Sharp.ExpandCircleDown") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 15.5f)
                lineTo(7.5f, 11.0f)
                lineToRelative(1.42f, -1.41f)
                lineTo(12.0f, 12.67f)
                lineToRelative(3.08f, -3.08f)
                lineTo(16.5f, 11.0f)
                lineTo(12.0f, 15.5f)
                close()
            }
        }
        return _expandCircleDown!!
    }

private var _expandCircleDown: ImageVector? = null
