/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.GasMeter: ImageVector
    get() {
        if (_gasMeter != null) {
            return _gasMeter!!
        }
        _gasMeter = materialIcon(name = "Sharp.GasMeter") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.1f, -2.5f, -2.46f)
                curveToRelative(0.0f, -1.09f, 0.43f, -1.39f, 2.5f, -3.79f)
                curveToRelative(2.05f, 2.38f, 2.5f, 2.7f, 2.5f, 3.79f)
                curveTo(14.5f, 16.9f, 13.38f, 18.0f, 12.0f, 18.0f)
                close()
                moveTo(16.0f, 10.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(10.0f)
                close()
            }
        }
        return _gasMeter!!
    }

private var _gasMeter: ImageVector? = null
