/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.KeyboardBackspace",
    ReplaceWith( "Icons.AutoMirrored.Sharp.KeyboardBackspace",
            "androidx.compose.material.icons.automirrored.sharp.KeyboardBackspace"),
)
public val Icons.Sharp.KeyboardBackspace: ImageVector
    get() {
        if (_keyboardBackspace != null) {
            return _keyboardBackspace!!
        }
        _keyboardBackspace = materialIcon(name = "Sharp.KeyboardBackspace") {
            materialPath {
                moveTo(21.0f, 11.0f)
                horizontalLineTo(6.83f)
                lineToRelative(3.58f, -3.59f)
                lineTo(9.0f, 6.0f)
                lineToRelative(-6.0f, 6.0f)
                lineToRelative(6.0f, 6.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(6.83f, 13.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(-2.0f)
                close()
            }
        }
        return _keyboardBackspace!!
    }

private var _keyboardBackspace: ImageVector? = null
