/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Man3: ImageVector
    get() {
        if (_man3 != null) {
            return _man3!!
        }
        _man3 = materialIcon(name = "Sharp.Man3") {
            materialPath {
                moveTo(16.0f, 7.0f)
                lineToRelative(-8.0f, 0.0f)
                lineToRelative(0.0f, 8.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(2.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 1.751f)
                lineToRelative(2.249f, 2.249f)
                lineToRelative(-2.249f, 2.249f)
                lineToRelative(-2.249f, -2.249f)
                close()
            }
        }
        return _man3!!
    }

private var _man3: ImageVector? = null
