/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Map: ImageVector
    get() {
        if (_map != null) {
            return _map!!
        }
        _map = materialIcon(name = "Sharp.Map") {
            materialPath {
                moveTo(15.0f, 5.1f)
                lineTo(9.0f, 3.0f)
                lineTo(3.0f, 5.02f)
                verticalLineToRelative(16.2f)
                lineToRelative(6.0f, -2.33f)
                lineToRelative(6.0f, 2.1f)
                lineToRelative(6.0f, -2.02f)
                lineTo(21.0f, 2.77f)
                lineTo(15.0f, 5.1f)
                close()
                moveTo(15.0f, 18.89f)
                lineToRelative(-6.0f, -2.11f)
                lineTo(9.0f, 5.11f)
                lineToRelative(6.0f, 2.11f)
                verticalLineToRelative(11.67f)
                close()
            }
        }
        return _map!!
    }

private var _map: ImageVector? = null
