/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NetworkLocked: ImageVector
    get() {
        if (_networkLocked != null) {
            return _networkLocked!!
        }
        _networkLocked = materialIcon(name = "Sharp.NetworkLocked") {
            materialPath {
                moveTo(22.0f, 16.0f)
                verticalLineToRelative(-0.36f)
                curveToRelative(0.0f, -1.31f, -0.94f, -2.5f, -2.24f, -2.63f)
                curveToRelative(-1.5f, -0.15f, -2.76f, 1.02f, -2.76f, 2.49f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(-1.0f)
                close()
                moveTo(21.0f, 16.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0.0f, -0.83f, 0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                verticalLineToRelative(0.5f)
                close()
                moveTo(19.5f, 11.0f)
                curveToRelative(0.15f, 0.0f, 0.3f, 0.01f, 0.46f, 0.02f)
                curveToRelative(0.01f, 0.0f, 0.03f, 0.01f, 0.04f, 0.01f)
                lineTo(20.0f, 1.0f)
                lineTo(1.0f, 20.0f)
                horizontalLineToRelative(13.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(1.26f)
                curveToRelative(0.22f, -0.63f, 0.58f, -1.2f, 1.06f, -1.68f)
                curveToRelative(0.85f, -0.85f, 1.98f, -1.32f, 3.18f, -1.32f)
                close()
            }
        }
        return _networkLocked!!
    }

private var _networkLocked: ImageVector? = null
