/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.PhoneCallback",
    ReplaceWith( "Icons.AutoMirrored.Sharp.PhoneCallback",
            "androidx.compose.material.icons.automirrored.sharp.PhoneCallback"),
)
public val Icons.Sharp.PhoneCallback: ImageVector
    get() {
        if (_phoneCallback != null) {
            return _phoneCallback!!
        }
        _phoneCallback = materialIcon(name = "Sharp.PhoneCallback") {
            materialPath {
                moveTo(15.73f, 14.85f)
                lineToRelative(-2.52f, 2.52f)
                curveToRelative(-2.83f, -1.44f, -5.15f, -3.75f, -6.59f, -6.59f)
                lineToRelative(2.53f, -2.53f)
                lineTo(8.54f, 3.0f)
                horizontalLineTo(3.03f)
                curveTo(2.45f, 13.18f, 10.82f, 21.55f, 21.0f, 20.97f)
                verticalLineToRelative(-5.51f)
                lineToRelative(-5.27f, -0.61f)
                close()
                moveTo(18.0f, 9.0f)
                horizontalLineToRelative(-2.59f)
                lineToRelative(5.02f, -5.02f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(14.0f, 7.59f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(6.0f)
                close()
            }
        }
        return _phoneCallback!!
    }

private var _phoneCallback: ImageVector? = null
