/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TakeoutDining: ImageVector
    get() {
        if (_takeoutDining != null) {
            return _takeoutDining!!
        }
        _takeoutDining = materialIcon(name = "Sharp.TakeoutDining") {
            materialPath {
                moveTo(22.0f, 7.46f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-1.59f, 1.58f)
                lineToRelative(0.03f, -0.56f)
                lineToRelative(-4.05f, -4.07f)
                lineToRelative(-5.96f, 0.0f)
                lineToRelative(-4.05f, 4.07f)
                lineToRelative(0.03f, 0.5f)
                lineToRelative(-1.59f, -1.56f)
                lineToRelative(-1.41f, 1.43f)
                lineToRelative(2.66f, 2.56f)
                lineToRelative(14.69f, 0.0f)
                close()
            }
            materialPath {
                moveTo(5.93f, 20.0f)
                lineToRelative(12.14f, 0.0f)
                lineToRelative(0.63f, -8.45f)
                lineToRelative(-13.4f, 0.0f)
                close()
            }
        }
        return _takeoutDining!!
    }

private var _takeoutDining: ImageVector? = null
