/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Tour: ImageVector
    get() {
        if (_tour != null) {
            return _tour!!
        }
        _tour = materialIcon(name = "Sharp.Tour") {
            materialPath {
                moveTo(21.0f, 4.0f)
                horizontalLineToRelative(-8.0f)
                horizontalLineToRelative(-1.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(2.0f)
                verticalLineToRelative(10.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(4.0f)
                horizontalLineToRelative(1.0f)
                horizontalLineToRelative(9.0f)
                lineToRelative(-2.0f, -5.0f)
                lineTo(21.0f, 4.0f)
                close()
                moveTo(15.0f, 9.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(15.0f, 7.9f, 15.0f, 9.0f)
                close()
            }
        }
        return _tour!!
    }

private var _tour: ImageVector? = null
