/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WavingHand: ImageVector
    get() {
        if (_wavingHand != null) {
            return _wavingHand!!
        }
        _wavingHand = materialIcon(name = "Sharp.WavingHand") {
            materialPath {
                moveTo(23.0f, 17.0f)
                curveToRelative(0.0f, 3.31f, -2.69f, 6.0f, -6.0f, 6.0f)
                verticalLineToRelative(-1.5f)
                curveToRelative(2.48f, 0.0f, 4.5f, -2.02f, 4.5f, -4.5f)
                horizontalLineTo(23.0f)
                close()
                moveTo(1.0f, 7.0f)
                curveToRelative(0.0f, -3.31f, 2.69f, -6.0f, 6.0f, -6.0f)
                verticalLineToRelative(1.5f)
                curveTo(4.52f, 2.5f, 2.5f, 4.52f, 2.5f, 7.0f)
                horizontalLineTo(1.0f)
                close()
                moveTo(8.9f, 3.43f)
                lineTo(3.42f, 8.91f)
                curveToRelative(-3.22f, 3.22f, -3.22f, 8.44f, 0.0f, 11.67f)
                reflectiveCurveToRelative(8.44f, 3.22f, 11.67f, 0.0f)
                lineToRelative(7.95f, -7.95f)
                lineToRelative(-1.77f, -1.77f)
                lineToRelative(-5.3f, 5.3f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(7.42f, -7.42f)
                lineToRelative(-1.77f, -1.77f)
                lineToRelative(-6.72f, 6.72f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(7.78f, -7.78f)
                lineTo(19.5f, 2.73f)
                lineToRelative(-7.78f, 7.78f)
                lineTo(11.02f, 9.8f)
                lineToRelative(6.36f, -6.36f)
                lineToRelative(-1.77f, -1.77f)
                lineToRelative(-8.51f, 8.51f)
                curveToRelative(1.22f, 1.57f, 1.11f, 3.84f, -0.33f, 5.28f)
                lineToRelative(-0.71f, -0.71f)
                curveToRelative(1.17f, -1.17f, 1.17f, -3.08f, 0.0f, -4.24f)
                lineToRelative(-0.35f, -0.35f)
                lineToRelative(4.95f, -4.95f)
                lineTo(8.9f, 3.43f)
                close()
            }
        }
        return _wavingHand!!
    }

private var _wavingHand: ImageVector? = null
