/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AutoFixNormal: ImageVector
    get() {
        if (_autoFixNormal != null) {
            return _autoFixNormal!!
        }
        _autoFixNormal = materialIcon(name = "TwoTone.AutoFixNormal") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.415f, 18.167f)
                lineToRelative(7.17f, -7.17f)
                lineToRelative(1.414f, 1.414f)
                lineToRelative(-7.17f, 7.17f)
                close()
            }
            materialPath {
                moveTo(20.0f, 7.0f)
                lineToRelative(0.94f, -2.06f)
                lineToRelative(2.06f, -0.94f)
                lineToRelative(-2.06f, -0.94f)
                lineToRelative(-0.94f, -2.06f)
                lineToRelative(-0.94f, 2.06f)
                lineToRelative(-2.06f, 0.94f)
                lineToRelative(2.06f, 0.94f)
                close()
            }
            materialPath {
                moveTo(17.71f, 9.12f)
                lineToRelative(-2.83f, -2.83f)
                curveTo(14.68f, 6.1f, 14.43f, 6.0f, 14.17f, 6.0f)
                curveToRelative(-0.26f, 0.0f, -0.51f, 0.1f, -0.71f, 0.29f)
                lineTo(2.29f, 17.46f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.83f, 2.83f)
                curveTo(5.32f, 21.9f, 5.57f, 22.0f, 5.83f, 22.0f)
                reflectiveCurveToRelative(0.51f, -0.1f, 0.71f, -0.29f)
                lineToRelative(11.17f, -11.17f)
                curveTo(18.1f, 10.15f, 18.1f, 9.51f, 17.71f, 9.12f)
                close()
                moveTo(5.83f, 19.59f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(11.59f, 11.0f)
                lineTo(13.0f, 12.41f)
                lineTo(5.83f, 19.59f)
                close()
                moveTo(14.41f, 11.0f)
                lineTo(13.0f, 9.59f)
                lineToRelative(1.17f, -1.17f)
                lineToRelative(1.41f, 1.41f)
                lineTo(14.41f, 11.0f)
                close()
            }
        }
        return _autoFixNormal!!
    }

private var _autoFixNormal: ImageVector? = null
