/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.CallMerge",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.CallMerge",
            "androidx.compose.material.icons.automirrored.twotone.CallMerge"),
)
public val Icons.TwoTone.CallMerge: ImageVector
    get() {
        if (_callMerge != null) {
            return _callMerge!!
        }
        _callMerge = materialIcon(name = "TwoTone.CallMerge") {
            materialPath {
                moveTo(16.997f, 20.41f)
                lineToRelative(-3.408f, -3.407f)
                lineToRelative(1.4f, -1.407f)
                lineToRelative(3.41f, 3.408f)
                close()
                moveTo(5.59f, 19.0f)
                lineTo(7.0f, 20.41f)
                lineToRelative(6.0f, -6.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(3.5f)
                lineTo(12.0f, 3.5f)
                lineTo(7.5f, 8.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(5.59f)
                close()
            }
        }
        return _callMerge!!
    }

private var _callMerge: ImageVector? = null
