/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Festival: ImageVector
    get() {
        if (_festival != null) {
            return _festival!!
        }
        _festival = materialIcon(name = "TwoTone.Festival") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.24f, 14.42f)
                curveTo(5.2f, 16.18f, 5.06f, 18.14f, 4.66f, 20.0f)
                horizontalLineToRelative(2.67f)
                curveToRelative(0.27f, -1.94f, 0.43f, -4.07f, 0.52f, -5.93f)
                curveTo(7.54f, 13.9f, 7.25f, 13.7f, 7.0f, 13.44f)
                curveTo(6.53f, 13.93f, 5.92f, 14.27f, 5.24f, 14.42f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.0f, 11.0f)
                horizontalLineTo(8.0f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveTo(11.0f, 11.83f, 11.0f, 11.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 11.0f)
                horizontalLineTo(3.0f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveTo(6.0f, 11.83f, 6.0f, 11.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.71f)
                curveTo(10.67f, 5.85f, 8.51f, 7.55f, 5.89f, 9.0f)
                horizontalLineToRelative(12.23f)
                curveTo(15.49f, 7.55f, 13.33f, 5.85f, 12.0f, 4.71f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.5f, 12.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                horizontalLineToRelative(-3.0f)
                curveTo(18.0f, 11.83f, 18.67f, 12.5f, 19.5f, 12.5f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.5f, 12.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                horizontalLineToRelative(-3.0f)
                curveTo(13.0f, 11.83f, 13.67f, 12.5f, 14.5f, 12.5f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.0f, 13.44f)
                curveToRelative(-0.25f, 0.25f, -0.54f, 0.45f, -0.85f, 0.62f)
                curveToRelative(0.1f, 1.87f, 0.26f, 4.0f, 0.52f, 5.93f)
                horizontalLineToRelative(2.67f)
                curveToRelative(-0.39f, -1.86f, -0.54f, -3.82f, -0.57f, -5.58f)
                curveTo(18.08f, 14.27f, 17.47f, 13.93f, 17.0f, 13.44f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveToRelative(0.0f, 0.0f, -5.0f, 5.0f, -11.0f, 7.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.49f, 0.93f, 2.75f, 2.24f, 3.26f)
                curveTo(3.2f, 16.76f, 2.92f, 19.69f, 2.0f, 22.0f)
                horizontalLineToRelative(20.0f)
                curveToRelative(-0.92f, -2.31f, -1.2f, -5.24f, -1.24f, -7.74f)
                curveTo(22.07f, 13.75f, 23.0f, 12.49f, 23.0f, 11.0f)
                verticalLineTo(9.0f)
                curveTo(17.0f, 7.0f, 12.0f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 4.71f)
                curveToRelative(1.33f, 1.14f, 3.49f, 2.84f, 6.11f, 4.29f)
                horizontalLineTo(5.89f)
                curveTo(8.51f, 7.55f, 10.67f, 5.85f, 12.0f, 4.71f)
                close()
                moveTo(3.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(3.0f, 11.83f, 3.0f, 11.0f)
                close()
                moveTo(7.33f, 20.0f)
                horizontalLineTo(4.66f)
                curveToRelative(0.39f, -1.86f, 0.54f, -3.82f, 0.57f, -5.58f)
                curveToRelative(0.68f, -0.15f, 1.29f, -0.49f, 1.76f, -0.98f)
                curveToRelative(0.25f, 0.25f, 0.54f, 0.45f, 0.85f, 0.62f)
                curveTo(7.76f, 15.93f, 7.6f, 18.06f, 7.33f, 20.0f)
                close()
                moveTo(8.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(8.0f, 11.83f, 8.0f, 11.0f)
                close()
                moveTo(9.35f, 20.0f)
                curveToRelative(0.24f, -1.83f, 0.39f, -3.78f, 0.48f, -5.53f)
                curveToRelative(0.84f, -0.08f, 1.61f, -0.45f, 2.17f, -1.02f)
                curveToRelative(0.56f, 0.57f, 1.32f, 0.94f, 2.17f, 1.02f)
                curveToRelative(0.1f, 1.75f, 0.24f, 3.7f, 0.48f, 5.53f)
                horizontalLineTo(9.35f)
                close()
                moveTo(14.5f, 12.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                horizontalLineToRelative(3.0f)
                curveTo(16.0f, 11.83f, 15.33f, 12.5f, 14.5f, 12.5f)
                close()
                moveTo(16.67f, 20.0f)
                curveToRelative(-0.27f, -1.94f, -0.43f, -4.07f, -0.52f, -5.93f)
                curveToRelative(0.31f, -0.17f, 0.61f, -0.37f, 0.85f, -0.62f)
                curveToRelative(0.47f, 0.48f, 1.08f, 0.83f, 1.76f, 0.98f)
                curveToRelative(0.03f, 1.76f, 0.18f, 3.72f, 0.57f, 5.58f)
                horizontalLineTo(16.67f)
                close()
                moveTo(19.5f, 12.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                horizontalLineToRelative(3.0f)
                curveTo(21.0f, 11.83f, 20.33f, 12.5f, 19.5f, 12.5f)
                close()
            }
        }
        return _festival!!
    }

private var _festival: ImageVector? = null
