/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FiberNew: ImageVector
    get() {
        if (_fiberNew != null) {
            return _fiberNew!!
        }
        _fiberNew = materialIcon(name = "TwoTone.FiberNew") {
            materialPath {
                moveTo(9.12f, 14.47f)
                lineTo(9.12f, 9.53f)
                lineTo(8.09f, 9.53f)
                verticalLineToRelative(2.88f)
                lineTo(6.03f, 9.53f)
                lineTo(5.0f, 9.53f)
                verticalLineToRelative(4.94f)
                horizontalLineToRelative(1.03f)
                verticalLineToRelative(-2.88f)
                lineToRelative(2.1f, 2.88f)
                close()
                moveTo(13.24f, 10.57f)
                lineTo(13.24f, 9.53f)
                horizontalLineToRelative(-3.3f)
                verticalLineToRelative(4.94f)
                horizontalLineToRelative(3.3f)
                verticalLineToRelative(-1.03f)
                horizontalLineToRelative(-2.06f)
                verticalLineToRelative(-0.91f)
                horizontalLineToRelative(2.06f)
                verticalLineToRelative(-1.04f)
                horizontalLineToRelative(-2.06f)
                verticalLineToRelative(-0.92f)
                close()
                moveTo(14.06f, 9.53f)
                verticalLineToRelative(4.12f)
                curveToRelative(0.0f, 0.45f, 0.37f, 0.82f, 0.82f, 0.82f)
                horizontalLineToRelative(3.29f)
                curveToRelative(0.45f, 0.0f, 0.82f, -0.37f, 0.82f, -0.82f)
                lineTo(18.99f, 9.53f)
                horizontalLineToRelative(-1.03f)
                verticalLineToRelative(3.71f)
                horizontalLineToRelative(-0.92f)
                verticalLineToRelative(-2.89f)
                horizontalLineToRelative(-1.03f)
                verticalLineToRelative(2.9f)
                horizontalLineToRelative(-0.93f)
                lineTo(15.08f, 9.53f)
                horizontalLineToRelative(-1.02f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 6.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(12.0f)
                horizontalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.11f, 0.0f, -1.99f, 0.89f, -1.99f, 2.0f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(20.0f, 18.0f)
                lineTo(4.0f, 18.0f)
                lineTo(4.0f, 6.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(12.0f)
                close()
            }
        }
        return _fiberNew!!
    }

private var _fiberNew: ImageVector? = null
