/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FlipCameraIos: ImageVector
    get() {
        if (_flipCameraIos != null) {
            return _flipCameraIos!!
        }
        _flipCameraIos = materialIcon(name = "TwoTone.FlipCameraIos") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.12f, 5.0f)
                horizontalLineTo(9.88f)
                lineTo(8.05f, 7.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-4.05f)
                lineTo(14.12f, 5.0f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                horizontalLineTo(5.0f)
                lineToRelative(2.49f, -2.49f)
                lineTo(7.5f, 10.5f)
                lineTo(10.0f, 13.0f)
                horizontalLineTo(9.97f)
                horizontalLineTo(8.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(0.58f, 0.0f, 1.13f, -0.13f, 1.62f, -0.35f)
                lineToRelative(0.74f, 0.74f)
                curveTo(13.65f, 17.76f, 12.86f, 18.0f, 12.0f, 18.0f)
                close()
                moveTo(19.0f, 13.0f)
                lineToRelative(-2.49f, 2.49f)
                lineTo(16.5f, 15.5f)
                lineTo(14.0f, 13.0f)
                horizontalLineToRelative(0.03f)
                horizontalLineTo(16.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                curveToRelative(-0.58f, 0.0f, -1.13f, 0.13f, -1.62f, 0.35f)
                lineTo(9.64f, 8.62f)
                curveTo(10.35f, 8.24f, 11.14f, 8.0f, 12.0f, 8.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                horizontalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 5.0f)
                horizontalLineToRelative(-3.17f)
                lineTo(15.0f, 3.0f)
                horizontalLineTo(9.0f)
                lineTo(7.17f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 5.0f, 2.0f, 5.9f, 2.0f, 7.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(7.0f)
                curveTo(22.0f, 5.9f, 21.1f, 5.0f, 20.0f, 5.0f)
                close()
                moveTo(20.0f, 19.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(4.05f)
                lineToRelative(1.83f, -2.0f)
                horizontalLineToRelative(4.24f)
                lineToRelative(1.83f, 2.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 17.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                horizontalLineToRelative(1.97f)
                horizontalLineTo(10.0f)
                lineToRelative(-2.5f, -2.5f)
                lineToRelative(-0.01f, 0.01f)
                lineTo(5.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                curveToRelative(0.86f, 0.0f, 1.65f, -0.24f, 2.36f, -0.62f)
                lineToRelative(-0.74f, -0.74f)
                curveTo(13.13f, 16.87f, 12.58f, 17.0f, 12.0f, 17.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 8.0f)
                curveToRelative(-0.86f, 0.0f, -1.65f, 0.24f, -2.36f, 0.62f)
                lineToRelative(0.74f, 0.73f)
                curveTo(10.87f, 9.13f, 11.42f, 9.0f, 12.0f, 9.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, 1.79f, 4.0f, 4.0f)
                horizontalLineToRelative(-1.97f)
                horizontalLineTo(14.0f)
                lineToRelative(2.5f, 2.5f)
                lineToRelative(0.01f, -0.01f)
                lineTo(19.0f, 13.0f)
                horizontalLineToRelative(-2.0f)
                curveTo(17.0f, 10.24f, 14.76f, 8.0f, 12.0f, 8.0f)
                close()
            }
        }
        return _flipCameraIos!!
    }

private var _flipCameraIos: ImageVector? = null
