/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Hardware: ImageVector
    get() {
        if (_hardware != null) {
            return _hardware!!
        }
        _hardware = materialIcon(name = "TwoTone.Hardware") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.77f, 6.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(9.0f)
                curveTo(8.11f, 5.0f, 7.32f, 5.39f, 6.77f, 6.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 3.0f)
                lineToRelative(-3.0f, 3.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(9.0f)
                curveTo(6.24f, 3.0f, 4.0f, 5.24f, 4.0f, 8.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(8.0f)
                lineToRelative(3.0f, 3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(18.0f)
                close()
                moveTo(13.0f, 19.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(13.0f, 11.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(6.77f)
                curveTo(7.32f, 5.39f, 8.11f, 5.0f, 9.0f, 5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(11.0f)
                close()
            }
        }
        return _hardware!!
    }

private var _hardware: ImageVector? = null
