/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ImportContacts: ImageVector
    get() {
        if (_importContacts != null) {
            return _importContacts!!
        }
        _importContacts = materialIcon(name = "TwoTone.ImportContacts") {
            materialPath {
                moveTo(21.0f, 5.0f)
                curveToRelative(-1.11f, -0.35f, -2.33f, -0.5f, -3.5f, -0.5f)
                curveToRelative(-1.95f, 0.0f, -4.05f, 0.4f, -5.5f, 1.5f)
                curveToRelative(-1.45f, -1.1f, -3.55f, -1.5f, -5.5f, -1.5f)
                reflectiveCurveTo(2.45f, 4.9f, 1.0f, 6.0f)
                verticalLineToRelative(14.65f)
                curveToRelative(0.0f, 0.25f, 0.25f, 0.5f, 0.5f, 0.5f)
                curveToRelative(0.1f, 0.0f, 0.15f, -0.05f, 0.25f, -0.05f)
                curveTo(3.1f, 20.45f, 5.05f, 20.0f, 6.5f, 20.0f)
                curveToRelative(1.95f, 0.0f, 4.05f, 0.4f, 5.5f, 1.5f)
                curveToRelative(1.35f, -0.85f, 3.8f, -1.5f, 5.5f, -1.5f)
                curveToRelative(1.65f, 0.0f, 3.35f, 0.3f, 4.75f, 1.05f)
                curveToRelative(0.1f, 0.05f, 0.15f, 0.05f, 0.25f, 0.05f)
                curveToRelative(0.25f, 0.0f, 0.5f, -0.25f, 0.5f, -0.5f)
                lineTo(23.0f, 6.0f)
                curveToRelative(-0.6f, -0.45f, -1.25f, -0.75f, -2.0f, -1.0f)
                close()
                moveTo(3.0f, 18.5f)
                lineTo(3.0f, 7.0f)
                curveToRelative(1.1f, -0.35f, 2.3f, -0.5f, 3.5f, -0.5f)
                curveToRelative(1.34f, 0.0f, 3.13f, 0.41f, 4.5f, 0.99f)
                verticalLineToRelative(11.5f)
                curveTo(9.63f, 18.41f, 7.84f, 18.0f, 6.5f, 18.0f)
                curveToRelative(-1.2f, 0.0f, -2.4f, 0.15f, -3.5f, 0.5f)
                close()
                moveTo(21.0f, 18.5f)
                curveToRelative(-1.1f, -0.35f, -2.3f, -0.5f, -3.5f, -0.5f)
                curveToRelative(-1.34f, 0.0f, -3.13f, 0.41f, -4.5f, 0.99f)
                lineTo(13.0f, 7.49f)
                curveToRelative(1.37f, -0.59f, 3.16f, -0.99f, 4.5f, -0.99f)
                curveToRelative(1.2f, 0.0f, 2.4f, 0.15f, 3.5f, 0.5f)
                verticalLineToRelative(11.5f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.0f, 7.49f)
                curveToRelative(-1.37f, -0.58f, -3.16f, -0.99f, -4.5f, -0.99f)
                curveToRelative(-1.2f, 0.0f, -2.4f, 0.15f, -3.5f, 0.5f)
                verticalLineToRelative(11.5f)
                curveToRelative(1.1f, -0.35f, 2.3f, -0.5f, 3.5f, -0.5f)
                curveToRelative(1.34f, 0.0f, 3.13f, 0.41f, 4.5f, 0.99f)
                verticalLineTo(7.49f)
                close()
            }
        }
        return _importContacts!!
    }

private var _importContacts: ImageVector? = null
