/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.ManageSearch",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.ManageSearch",
            "androidx.compose.material.icons.automirrored.twotone.ManageSearch"),
)
public val Icons.TwoTone.ManageSearch: ImageVector
    get() {
        if (_manageSearch != null) {
            return _manageSearch!!
        }
        _manageSearch = materialIcon(name = "TwoTone.ManageSearch") {
            materialPath {
                moveTo(2.0f, 12.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(18.17f, 13.75f)
                curveTo(18.69f, 12.96f, 19.0f, 12.02f, 19.0f, 11.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                reflectiveCurveToRelative(-5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                curveToRelative(1.02f, 0.0f, 1.96f, -0.31f, 2.76f, -0.83f)
                lineTo(20.59f, 19.0f)
                lineTo(22.0f, 17.59f)
                lineTo(18.17f, 13.75f)
                close()
                moveTo(14.0f, 14.0f)
                curveToRelative(-1.65f, 0.0f, -3.0f, -1.35f, -3.0f, -3.0f)
                curveToRelative(0.0f, -1.65f, 1.35f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.35f, 3.0f, 3.0f)
                curveTo(17.0f, 12.65f, 15.65f, 14.0f, 14.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(2.0f, 7.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(2.0f, 17.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-10.0f)
                close()
            }
        }
        return _manageSearch!!
    }

private var _manageSearch: ImageVector? = null
