/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.NetworkPing: ImageVector
    get() {
        if (_networkPing != null) {
            return _networkPing!!
        }
        _networkPing = materialIcon(name = "TwoTone.NetworkPing") {
            materialPath {
                moveTo(12.0f, 14.67f)
                lineTo(3.41f, 6.09f)
                lineTo(2.0f, 7.5f)
                lineToRelative(8.5f, 8.5f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-6.5f)
                lineToRelative(5.15f, -5.15f)
                curveTo(18.91f, 10.95f, 19.2f, 11.0f, 19.5f, 11.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                reflectiveCurveTo(20.88f, 6.0f, 19.5f, 6.0f)
                reflectiveCurveTo(17.0f, 7.12f, 17.0f, 8.5f)
                curveToRelative(0.0f, 0.35f, 0.07f, 0.67f, 0.2f, 0.97f)
                lineTo(12.0f, 14.67f)
                close()
            }
        }
        return _networkPing!!
    }

private var _networkPing: ImageVector? = null
