/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PanoramaHorizontalSelect: ImageVector
    get() {
        if (_panoramaHorizontalSelect != null) {
            return _panoramaHorizontalSelect!!
        }
        _panoramaHorizontalSelect = materialIcon(name = "TwoTone.PanoramaHorizontalSelect") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 6.38f)
                verticalLineToRelative(11.25f)
                curveToRelative(2.01f, -0.59f, 4.61f, -1.13f, 8.0f, -1.13f)
                curveToRelative(3.38f, 0.0f, 5.99f, 0.54f, 8.0f, 1.13f)
                verticalLineTo(6.37f)
                curveToRelative(-2.01f, 0.59f, -4.62f, 1.13f, -8.0f, 1.13f)
                curveTo(9.32f, 7.5f, 6.58f, 7.11f, 4.0f, 6.38f)
                close()
            }
            materialPath {
                moveTo(21.01f, 4.0f)
                curveTo(20.45f, 4.0f, 17.4f, 5.5f, 12.0f, 5.5f)
                curveToRelative(-5.31f, 0.0f, -8.49f, -1.49f, -9.01f, -1.49f)
                curveTo(2.46f, 4.01f, 2.0f, 4.45f, 2.0f, 5.02f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 0.57f, 0.46f, 1.0f, 0.99f, 1.0f)
                curveToRelative(0.57f, 0.0f, 3.55f, -1.5f, 9.01f, -1.5f)
                curveToRelative(5.42f, 0.0f, 8.44f, 1.5f, 9.01f, 1.5f)
                curveToRelative(0.53f, 0.0f, 0.99f, -0.43f, 0.99f, -1.0f)
                verticalLineTo(5.0f)
                curveTo(22.0f, 4.43f, 21.54f, 4.0f, 21.01f, 4.0f)
                close()
                moveTo(20.0f, 17.63f)
                curveToRelative(-2.01f, -0.59f, -4.62f, -1.13f, -8.0f, -1.13f)
                curveToRelative(-3.39f, 0.0f, -5.99f, 0.54f, -8.0f, 1.13f)
                verticalLineTo(6.38f)
                curveTo(6.58f, 7.11f, 9.32f, 7.5f, 12.0f, 7.5f)
                curveToRelative(3.38f, 0.0f, 5.99f, -0.54f, 8.0f, -1.13f)
                verticalLineTo(17.63f)
                close()
            }
        }
        return _panoramaHorizontalSelect!!
    }

private var _panoramaHorizontalSelect: ImageVector? = null
