/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PersonAddDisabled: ImageVector
    get() {
        if (_personAddDisabled != null) {
            return _personAddDisabled!!
        }
        _personAddDisabled = materialIcon(name = "TwoTone.PersonAddDisabled") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.0f, 18.0f)
                horizontalLineToRelative(5.87f)
                lineTo(13.0f, 16.13f)
                lineToRelative(-1.1f, 0.3f)
                curveTo(9.89f, 16.99f, 9.08f, 17.76f, 9.0f, 18.0f)
                close()
                moveTo(17.0f, 8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                curveToRelative(-0.99f, 0.0f, -1.81f, 0.72f, -1.97f, 1.67f)
                lineToRelative(2.31f, 2.31f)
                curveTo(16.27f, 9.82f, 17.0f, 8.99f, 17.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(14.48f, 11.95f)
                curveToRelative(0.17f, 0.02f, 0.34f, 0.05f, 0.52f, 0.05f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                reflectiveCurveToRelative(-1.79f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveToRelative(-4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 0.18f, 0.03f, 0.35f, 0.05f, 0.52f)
                lineToRelative(3.43f, 3.43f)
                close()
                moveTo(15.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 0.99f, -0.73f, 1.82f, -1.67f, 1.97f)
                lineToRelative(-2.31f, -2.31f)
                curveTo(13.19f, 6.72f, 14.01f, 6.0f, 15.0f, 6.0f)
                close()
                moveTo(16.69f, 14.16f)
                lineTo(22.53f, 20.0f)
                lineTo(23.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -2.14f, -3.56f, -3.5f, -6.31f, -3.84f)
                close()
                moveTo(0.0f, 3.12f)
                lineToRelative(4.0f, 4.0f)
                lineTo(4.0f, 10.0f)
                lineTo(1.0f, 10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.88f)
                lineToRelative(2.51f, 2.51f)
                curveTo(9.19f, 15.11f, 7.0f, 16.3f, 7.0f, 18.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(9.88f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(1.41f, 1.71f)
                lineTo(0.0f, 3.12f)
                close()
                moveTo(13.01f, 16.13f)
                lineTo(14.88f, 18.0f)
                lineTo(9.0f, 18.0f)
                curveToRelative(0.08f, -0.24f, 0.88f, -1.01f, 2.91f, -1.57f)
                lineToRelative(1.1f, -0.3f)
                close()
                moveTo(6.0f, 9.12f)
                lineToRelative(0.88f, 0.88f)
                lineTo(6.0f, 10.0f)
                verticalLineToRelative(-0.88f)
                close()
            }
        }
        return _personAddDisabled!!
    }

private var _personAddDisabled: ImageVector? = null
