/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.TaxiAlert: ImageVector
    get() {
        if (_taxiAlert != null) {
            return _taxiAlert!!
        }
        _taxiAlert = materialIcon(name = "TwoTone.TaxiAlert") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 18.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(15.5f, 14.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(16.33f, 17.0f, 15.5f, 17.0f)
                reflectiveCurveTo(14.0f, 16.33f, 14.0f, 15.5f)
                reflectiveCurveTo(14.67f, 14.0f, 15.5f, 14.0f)
                close()
                moveTo(6.5f, 14.0f)
                curveTo(7.33f, 14.0f, 8.0f, 14.67f, 8.0f, 15.5f)
                reflectiveCurveTo(7.33f, 17.0f, 6.5f, 17.0f)
                reflectiveCurveTo(5.0f, 16.33f, 5.0f, 15.5f)
                reflectiveCurveTo(5.67f, 14.0f, 6.5f, 14.0f)
                close()
            }
            materialPath {
                moveTo(6.5f, 15.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(15.5f, 15.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(18.0f, 18.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(-1.91f, 0.0f, -3.63f, -0.76f, -4.89f, -2.0f)
                horizontalLineTo(4.81f)
                lineToRelative(1.04f, -3.0f)
                horizontalLineToRelative(5.44f)
                curveTo(11.1f, 7.37f, 11.0f, 6.7f, 11.0f, 6.0f)
                reflectiveCurveToRelative(0.1f, -1.37f, 0.29f, -2.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(5.5f)
                curveTo(4.84f, 6.0f, 4.29f, 6.42f, 4.08f, 7.01f)
                lineTo(2.0f, 13.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-8.0f)
                lineToRelative(-0.09f, -0.27f)
                curveTo(19.3f, 12.9f, 18.66f, 13.0f, 18.0f, 13.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 1.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 1.0f, 18.0f, 1.0f)
                close()
                moveTo(18.5f, 3.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(18.5f)
                close()
                moveTo(18.5f, 9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(9.0f)
                close()
            }
        }
        return _taxiAlert!!
    }

private var _taxiAlert: ImageVector? = null
