/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Stream: ImageVector
    get() {
        if (_stream != null) {
            return _stream!!
        }
        _stream = materialIcon(name = "Filled.Stream") {
            materialPath {
                moveTo(20.0f, 12.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(4.0f, 12.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 20.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(10.05f, 8.59f)
                lineTo(6.03f, 4.55f)
                horizontalLineToRelative(-0.01f)
                lineToRelative(-0.31f, -0.32f)
                lineToRelative(-1.42f, 1.41f)
                lineToRelative(4.02f, 4.05f)
                lineToRelative(0.01f, -0.01f)
                lineToRelative(0.31f, 0.32f)
                close()
                moveTo(13.943f, 8.617f)
                lineToRelative(4.405f, -4.392f)
                lineTo(19.76f, 5.64f)
                lineToRelative(-4.405f, 4.393f)
                close()
                moveTo(10.01f, 15.36f)
                lineToRelative(-1.42f, -1.41f)
                lineToRelative(-4.03f, 4.01f)
                lineToRelative(-0.32f, 0.33f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(4.03f, -4.02f)
                close()
                moveTo(19.76f, 18.3f)
                lineToRelative(-3.99f, -4.01f)
                lineToRelative(-0.36f, -0.35f)
                lineTo(14.0f, 15.35f)
                lineToRelative(3.99f, 4.01f)
                lineToRelative(0.35f, 0.35f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _stream!!
    }

private var _stream: ImageVector? = null
