/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SouthWest: ImageVector
    get() {
        if (_southWest != null) {
            return _southWest!!
        }
        _southWest = materialIcon(name = "Outlined.SouthWest") {
            materialPath {
                moveTo(15.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(8.41f)
                lineTo(20.0f, 5.41f)
                lineTo(18.59f, 4.0f)
                lineTo(7.0f, 15.59f)
                verticalLineTo(9.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(10.0f)
                horizontalLineTo(15.0f)
                close()
            }
        }
        return _southWest!!
    }

private var _southWest: ImageVector? = null
