/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AreaChart: ImageVector
    get() {
        if (_areaChart != null) {
            return _areaChart!!
        }
        _areaChart = materialIcon(name = "Rounded.AreaChart") {
            materialPath {
                moveTo(8.0f, 17.0f)
                lineToRelative(3.39f, -4.66f)
                curveToRelative(0.33f, -0.46f, 0.98f, -0.55f, 1.42f, -0.2f)
                lineTo(21.0f, 18.5f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                lineToRelative(0.0f, -5.72f)
                curveToRelative(0.22f, 0.0f, 0.44f, 0.07f, 0.62f, 0.22f)
                lineTo(8.0f, 17.0f)
                close()
                moveTo(3.0f, 11.0f)
                curveToRelative(0.44f, 0.0f, 0.88f, 0.15f, 1.25f, 0.44f)
                lineToRelative(3.37f, 2.69f)
                lineToRelative(2.77f, -3.81f)
                curveToRelative(0.66f, -0.91f, 1.95f, -1.1f, 2.85f, -0.4f)
                lineTo(21.0f, 15.97f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(-4.18f, -3.34f)
                curveToRelative(-0.45f, -0.36f, -1.1f, -0.27f, -1.44f, 0.2f)
                lineTo(7.0f, 10.0f)
                lineTo(3.6f, 7.45f)
                curveTo(3.42f, 7.32f, 3.21f, 7.25f, 3.0f, 7.25f)
                lineTo(3.0f, 11.0f)
                close()
            }
        }
        return _areaChart!!
    }

private var _areaChart: ImageVector? = null
