/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TypeSpecimen: ImageVector
    get() {
        if (_typeSpecimen != null) {
            return _typeSpecimen!!
        }
        _typeSpecimen = materialIcon(name = "Rounded.TypeSpecimen") {
            materialPath {
                moveTo(3.0f, 6.0f)
                lineTo(3.0f, 6.0f)
                curveTo(2.45f, 6.0f, 2.0f, 6.45f, 2.0f, 7.0f)
                verticalLineToRelative(13.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(7.0f)
                curveTo(4.0f, 6.45f, 3.55f, 6.0f, 3.0f, 6.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 2.0f, 6.0f, 2.9f, 6.0f, 4.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(16.46f, 14.01f)
                lineToRelative(-0.63f, -1.82f)
                horizontalLineToRelative(-3.63f)
                lineToRelative(-0.65f, 1.82f)
                curveToRelative(-0.1f, 0.29f, -0.38f, 0.48f, -0.68f, 0.48f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.51f, 0.0f, -0.86f, -0.51f, -0.68f, -0.98f)
                lineToRelative(2.73f, -7.27f)
                curveTo(13.08f, 5.8f, 13.52f, 5.5f, 14.0f, 5.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.48f, 0.0f, 0.92f, 0.3f, 1.09f, 0.75f)
                lineToRelative(2.73f, 7.27f)
                curveToRelative(0.18f, 0.47f, -0.17f, 0.98f, -0.68f, 0.98f)
                horizontalLineToRelative(0.0f)
                curveTo(16.83f, 14.5f, 16.56f, 14.31f, 16.46f, 14.01f)
                close()
            }
            materialPath {
                moveTo(13.96f, 7.17f)
                lineToRelative(-1.31f, 3.72f)
                lineToRelative(2.69f, 0.0f)
                lineToRelative(-1.3f, -3.72f)
                close()
            }
        }
        return _typeSpecimen!!
    }

private var _typeSpecimen: ImageVector? = null
