/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VideocamOff: ImageVector
    get() {
        if (_videocamOff != null) {
            return _videocamOff!!
        }
        _videocamOff = materialIcon(name = "Sharp.VideocamOff") {
            materialPath {
                moveTo(21.0f, 16.61f)
                verticalLineTo(6.5f)
                lineToRelative(-4.0f, 4.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-6.61f)
                close()
                moveTo(3.41f, 1.86f)
                lineTo(2.0f, 3.27f)
                lineTo(4.73f, 6.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(13.73f)
                lineToRelative(3.0f, 3.0f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _videocamOff!!
    }

private var _videocamOff: ImageVector? = null
