/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SettingsSystemDaydream: ImageVector
    get() {
        if (_settingsSystemDaydream != null) {
            return _settingsSystemDaydream!!
        }
        _settingsSystemDaydream = materialIcon(name = "TwoTone.SettingsSystemDaydream") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.0f, 15.0f)
                horizontalLineToRelative(6.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveToRelative(-0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-0.87f)
                lineToRelative(-0.17f, -0.86f)
                curveTo(14.29f, 9.92f, 13.23f, 9.0f, 12.0f, 9.0f)
                curveToRelative(-0.96f, 0.0f, -1.84f, 0.57f, -2.26f, 1.45f)
                lineToRelative(-0.27f, 0.57f)
                horizontalLineToRelative(-0.73f)
                curveTo(7.74f, 11.15f, 7.0f, 11.99f, 7.0f, 13.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 17.0f)
                horizontalLineToRelative(6.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                curveToRelative(0.0f, -1.66f, -1.16f, -3.05f, -2.74f, -3.41f)
                curveTo(15.66f, 8.28f, 13.95f, 7.0f, 12.0f, 7.0f)
                curveToRelative(-1.53f, 0.0f, -2.96f, 0.8f, -3.78f, 2.08f)
                curveTo(6.36f, 9.44f, 5.0f, 11.07f, 5.0f, 13.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                close()
                moveTo(8.74f, 11.02f)
                horizontalLineToRelative(0.74f)
                lineToRelative(0.27f, -0.57f)
                curveTo(10.16f, 9.57f, 11.04f, 9.0f, 12.0f, 9.0f)
                curveToRelative(1.23f, 0.0f, 2.29f, 0.92f, 2.46f, 2.14f)
                lineToRelative(0.17f, 0.86f)
                horizontalLineToRelative(0.87f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                lineTo(9.0f, 15.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.01f, 0.74f, -1.85f, 1.74f, -1.98f)
                close()
                moveTo(21.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(21.0f, 19.01f)
                lineTo(3.0f, 19.01f)
                lineTo(3.0f, 4.99f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(14.02f)
                close()
            }
        }
        return _settingsSystemDaydream!!
    }

private var _settingsSystemDaydream: ImageVector? = null
