/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Diamond: ImageVector
    get() {
        if (_diamond != null) {
            return _diamond!!
        }
        _diamond = materialIcon(name = "Rounded.Diamond") {
            materialPath {
                moveTo(12.16f, 3.0f)
                lineToRelative(-0.32f, 0.0f)
                lineToRelative(-2.63f, 5.25f)
                lineToRelative(5.58f, 0.0f)
                close()
            }
            materialPath {
                moveTo(16.46f, 8.25f)
                horizontalLineToRelative(5.16f)
                lineToRelative(-2.07f, -4.14f)
                curveTo(19.21f, 3.43f, 18.52f, 3.0f, 17.76f, 3.0f)
                horizontalLineToRelative(-3.93f)
                lineTo(16.46f, 8.25f)
                close()
            }
            materialPath {
                moveTo(21.38f, 9.75f)
                lineToRelative(-8.63f, 0.0f)
                lineToRelative(0.0f, 10.35f)
                close()
            }
            materialPath {
                moveTo(11.25f, 20.1f)
                lineToRelative(0.0f, -10.35f)
                lineToRelative(-8.63f, 0.0f)
                close()
            }
            materialPath {
                moveTo(7.54f, 8.25f)
                lineTo(10.16f, 3.0f)
                horizontalLineTo(6.24f)
                curveTo(5.48f, 3.0f, 4.79f, 3.43f, 4.45f, 4.11f)
                lineTo(2.38f, 8.25f)
                horizontalLineTo(7.54f)
                close()
            }
        }
        return _diamond!!
    }

private var _diamond: ImageVector? = null
