/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Hive: ImageVector
    get() {
        if (_hive != null) {
            return _hive!!
        }
        _hive = materialIcon(name = "Rounded.Hive") {
            materialPath {
                moveTo(14.09f, 7.51f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveTo(13.91f, 2.18f, 13.58f, 2.0f, 13.23f, 2.0f)
                horizontalLineToRelative(-2.45f)
                curveToRelative(-0.35f, 0.0f, -0.68f, 0.18f, -0.86f, 0.49f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveTo(10.09f, 7.82f, 10.42f, 8.0f, 10.77f, 8.0f)
                horizontalLineToRelative(2.45f)
                curveTo(13.58f, 8.0f, 13.91f, 7.82f, 14.09f, 7.51f)
                close()
            }
            materialPath {
                moveTo(9.91f, 9.49f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveToRelative(0.18f, 0.3f, 0.51f, 0.49f, 0.86f, 0.49f)
                horizontalLineToRelative(2.46f)
                curveToRelative(0.35f, 0.0f, 0.68f, -0.18f, 0.86f, -0.49f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveTo(13.91f, 9.18f, 13.58f, 9.0f, 13.23f, 9.0f)
                horizontalLineToRelative(-2.46f)
                curveTo(10.42f, 9.0f, 10.09f, 9.18f, 9.91f, 9.49f)
                close()
            }
            materialPath {
                moveTo(17.01f, 11.51f)
                horizontalLineToRelative(2.45f)
                curveToRelative(0.35f, 0.0f, 0.68f, -0.18f, 0.86f, -0.49f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveToRelative(-0.18f, -0.3f, -0.51f, -0.49f, -0.86f, -0.49f)
                horizontalLineToRelative(-2.45f)
                curveToRelative(-0.35f, 0.0f, -0.68f, 0.18f, -0.86f, 0.49f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveTo(16.34f, 11.33f, 16.66f, 11.51f, 17.01f, 11.51f)
                close()
            }
            materialPath {
                moveTo(19.47f, 12.51f)
                horizontalLineToRelative(-2.46f)
                curveToRelative(-0.35f, 0.0f, -0.68f, 0.18f, -0.86f, 0.49f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveToRelative(0.18f, 0.3f, 0.51f, 0.49f, 0.86f, 0.49f)
                horizontalLineToRelative(2.46f)
                curveToRelative(0.35f, 0.0f, 0.68f, -0.18f, 0.86f, -0.49f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveTo(20.15f, 12.7f, 19.82f, 12.51f, 19.47f, 12.51f)
                close()
            }
            materialPath {
                moveTo(7.84f, 11.03f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveTo(7.66f, 5.7f, 7.34f, 5.51f, 6.99f, 5.51f)
                horizontalLineTo(4.53f)
                curveTo(4.18f, 5.51f, 3.85f, 5.7f, 3.67f, 6.0f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveToRelative(0.18f, 0.3f, 0.51f, 0.49f, 0.86f, 0.49f)
                horizontalLineToRelative(2.45f)
                curveTo(7.34f, 11.51f, 7.66f, 11.33f, 7.84f, 11.03f)
                close()
            }
            materialPath {
                moveTo(6.99f, 12.51f)
                horizontalLineTo(4.53f)
                curveToRelative(-0.35f, 0.0f, -0.68f, 0.18f, -0.86f, 0.49f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveToRelative(0.18f, 0.3f, 0.51f, 0.49f, 0.86f, 0.49f)
                horizontalLineToRelative(2.46f)
                curveToRelative(0.35f, 0.0f, 0.68f, -0.18f, 0.86f, -0.49f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveTo(7.66f, 12.7f, 7.34f, 12.51f, 6.99f, 12.51f)
                close()
            }
            materialPath {
                moveTo(9.91f, 16.49f)
                lineToRelative(-1.2f, 2.0f)
                curveToRelative(-0.19f, 0.32f, -0.19f, 0.71f, 0.0f, 1.03f)
                lineToRelative(1.2f, 2.0f)
                curveToRelative(0.18f, 0.3f, 0.51f, 0.49f, 0.86f, 0.49f)
                horizontalLineToRelative(2.46f)
                curveToRelative(0.35f, 0.0f, 0.68f, -0.18f, 0.86f, -0.49f)
                lineToRelative(1.2f, -2.0f)
                curveToRelative(0.19f, -0.32f, 0.19f, -0.71f, 0.0f, -1.03f)
                lineToRelative(-1.2f, -2.0f)
                curveToRelative(-0.18f, -0.3f, -0.51f, -0.49f, -0.86f, -0.49f)
                horizontalLineToRelative(-2.46f)
                curveTo(10.42f, 16.0f, 10.09f, 16.18f, 9.91f, 16.49f)
                close()
            }
        }
        return _hive!!
    }

private var _hive: ImageVector? = null
