/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Tornado: ImageVector
    get() {
        if (_tornado != null) {
            return _tornado!!
        }
        _tornado = materialIcon(name = "Rounded.Tornado") {
            materialPath {
                moveTo(20.11f, 8.0f)
                lineToRelative(1.16f, -2.0f)
                curveToRelative(0.77f, -1.33f, -0.19f, -3.0f, -1.73f, -3.0f)
                horizontalLineTo(4.47f)
                curveToRelative(-1.54f, 0.0f, -2.5f, 1.67f, -1.73f, 3.0f)
                lineToRelative(1.16f, 2.0f)
                horizontalLineTo(20.11f)
                close()
            }
            materialPath {
                moveTo(7.95f, 15.0f)
                lineToRelative(2.32f, 4.01f)
                curveToRelative(0.77f, 1.33f, 2.69f, 1.33f, 3.46f, 0.0f)
                lineTo(16.05f, 15.0f)
                horizontalLineTo(7.95f)
                close()
            }
            materialPath {
                moveTo(18.95f, 10.0f)
                lineToRelative(-13.9f, 0.0f)
                lineToRelative(1.74f, 3.0f)
                lineToRelative(10.42f, 0.0f)
                close()
            }
        }
        return _tornado!!
    }

private var _tornado: ImageVector? = null
