/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WifiTetheringError: ImageVector
    get() {
        if (_wifiTetheringError != null) {
            return _wifiTetheringError!!
        }
        _wifiTetheringError = materialIcon(name = "Rounded.WifiTetheringError") {
            materialPath {
                moveTo(10.66f, 7.14f)
                curveToRelative(-2.24f, 0.48f, -4.04f, 2.3f, -4.52f, 4.54f)
                curveToRelative(-0.37f, 1.75f, 0.02f, 3.38f, 0.89f, 4.66f)
                curveToRelative(0.34f, 0.51f, 1.08f, 0.55f, 1.51f, 0.11f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.35f, -0.35f, 0.37f, -0.88f, 0.1f, -1.28f)
                curveToRelative(-0.5f, -0.76f, -0.75f, -1.71f, -0.61f, -2.73f)
                curveToRelative(0.23f, -1.74f, 1.67f, -3.17f, 3.41f, -3.4f)
                curveTo(13.9f, 8.71f, 16.0f, 10.61f, 16.0f, 13.0f)
                curveToRelative(0.0f, 0.8f, -0.24f, 1.54f, -0.64f, 2.16f)
                curveToRelative(-0.27f, 0.41f, -0.25f, 0.95f, 0.1f, 1.29f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.43f, 0.43f, 1.17f, 0.4f, 1.51f, -0.11f)
                curveTo(17.62f, 15.4f, 18.0f, 14.25f, 18.0f, 13.0f)
                curveTo(18.0f, 9.25f, 14.55f, 6.3f, 10.66f, 7.14f)
                close()
                moveTo(10.25f, 3.15f)
                curveToRelative(-4.05f, 0.69f, -7.19f, 3.69f, -8.03f, 7.72f)
                curveToRelative(-0.66f, 3.17f, 0.2f, 6.16f, 1.97f, 8.38f)
                curveToRelative(0.37f, 0.46f, 1.07f, 0.49f, 1.49f, 0.07f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.36f, -0.36f, 0.39f, -0.93f, 0.07f, -1.32f)
                curveToRelative(-1.34f, -1.67f, -2.03f, -3.9f, -1.66f, -6.28f)
                curveToRelative(0.55f, -3.47f, 3.42f, -6.24f, 6.92f, -6.65f)
                curveToRelative(2.76f, -0.33f, 5.27f, 0.74f, 6.93f, 2.59f)
                curveTo(18.14f, 7.87f, 18.41f, 8.0f, 18.7f, 8.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.85f, 0.0f, 1.34f, -1.01f, 0.77f, -1.65f)
                curveTo(17.28f, 3.9f, 13.91f, 2.53f, 10.25f, 3.15f)
                close()
                moveTo(12.0f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                curveToRelative(0.0f, 0.55f, 0.23f, 1.05f, 0.59f, 1.41f)
                curveTo(10.95f, 14.77f, 11.45f, 15.0f, 12.0f, 15.0f)
                reflectiveCurveToRelative(1.05f, -0.23f, 1.41f, -0.59f)
                curveTo(13.77f, 14.05f, 14.0f, 13.55f, 14.0f, 13.0f)
                curveTo(14.0f, 11.9f, 13.1f, 11.0f, 12.0f, 11.0f)
                close()
                moveTo(21.0f, 10.0f)
                lineTo(21.0f, 10.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveTo(20.0f, 10.45f, 20.45f, 10.0f, 21.0f, 10.0f)
                close()
                moveTo(21.0f, 18.0f)
                lineTo(21.0f, 18.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(20.0f, 18.45f, 20.45f, 18.0f, 21.0f, 18.0f)
                close()
            }
        }
        return _wifiTetheringError!!
    }

private var _wifiTetheringError: ImageVector? = null
