/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BedroomParent: ImageVector
    get() {
        if (_bedroomParent != null) {
            return _bedroomParent!!
        }
        _bedroomParent = materialIcon(name = "Sharp.BedroomParent") {
            materialPath {
                moveTo(6.5f, 12.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-11.0f)
                close()
            }
            materialPath {
                moveTo(7.25f, 8.5f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(12.75f, 8.5f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(20.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(2.0f)
                close()
                moveTo(19.0f, 17.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-11.0f)
                verticalLineTo(17.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-5.0f)
                lineToRelative(0.65f, -0.55f)
                verticalLineTo(7.0f)
                horizontalLineTo(11.0f)
                curveToRelative(0.37f, 0.0f, 0.72f, 0.12f, 1.0f, 0.32f)
                curveTo(12.28f, 7.12f, 12.63f, 7.0f, 13.0f, 7.0f)
                horizontalLineToRelative(5.35f)
                verticalLineToRelative(4.45f)
                lineTo(19.0f, 12.0f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _bedroomParent!!
    }

private var _bedroomParent: ImageVector? = null
